<?php
/**
* Liquid Shape Divider Options
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

/**
 * [liquid_param_select_preview description]
 * @method liquid_param_select_preview
 * @param  [type]               $settings [description]
 * @param  [type]               $value    [description]
 * @return [type]                         [description]
 */
/*
vc_add_shortcode_param( 'css_responsive_editor', 'liquid_param_responsive_options' );
function liquid_param_responsive_options( $settings, $value ) {

	return 'Hi';

}
*/
if( ! class_exists( 'Liquid_Shape_Divider_Options' ) ) {

	class Liquid_Shape_Divider_Options  {

		/**
		 * @var array
		 */
		protected $positions = array( 'top', 'bottom' );

		function __construct() {

			if ( function_exists( 'vc_add_shortcode_param' ) ) {
				vc_add_shortcode_param( 'liquid_shape_divider', array( $this, 'shape_divider_param' ) );
			}
		}

		function shape_divider_param( $settings, $value ) {

			$label  = isset( $settings['label'] ) ? $settings['label'] : esc_html__( 'Shape Divider Options', 'landinghub-core' );
			$values = $this->get_shape_divider_values( $value );

			$positions = $this->positions;
			$i = 0;

			$output = '<div class="vc_css-editor vc_row vc_ui-flex-row">';
			$output .= '	<div class="vc_col-xs-12 liquid-shape-divider-tabs">';
			$output .= '		<h3 class="liquid-shape-divider-heading top active" data-target="top">' .  esc_html__( 'Top Divider', 'landinghub-core' )  . '</h3>';
			$output .= '		<h3 class="liquid-shape-divider-heading bottom" data-target="bottom">' .  esc_html__( 'Bottom Divider', 'landinghub-core' )  . '</h3>';
			$output .= '	</div>';
			
			foreach( $positions as $position ) {

				$hidden = ( $i != 0 ) ? 'hidden' : '';

				$output .= '	<div class="vc_col-xs-12 liquid_shape_divider_settings ' . $hidden . '" data-position="' . $position . '">';
				$output .= '		<div class="vc_row">';
				$output .= '			<div class="liquid_shape_divider_preview vc_col-xs-6"><div class="liquid_shape"></div></div>';
				$output .= '			<div class="vc_col-xs-6">';

				$output .= '<div class="liquid-inner-wrap">';

				// Shape type select
				$output .= '	<label>' . esc_html__( 'Shape Type', 'landinghub-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-type">'
						. '			<select data-name="' . $position . '-shape-type" data-preview-target=".liquid_shape" name="' . $position . '_shape_type" class="liquid_shape_divider-type">'
						.				$this->getShapeTypeOptions( $position,  $values )
						. '			</select>'
						. '		</div>';

				// Shape divider height
				$output .= '	<label>' . esc_html__( 'Height', 'landinghub-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-height">'
						.			$this->getShapeHeight( $position,  $values )
						. '		</div>';

				$output .= '<div class="liquid_shape_divider-bringtofront">'
						.			$this->shapeBringToFront( $position,  $values )
						. '		</div>';

				// Shape divider backround color
				$output .= '	<label>' . esc_html__( 'Color', 'landinghub-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-color">'
						.			$this->getShapeColor( $position,  $values )
						. '		</div>';

				$output .= '</div>'; //.liquid-inner-wrap

				$i++;

				$output .= '			</div>'; //.vc_col-xs-6
				$output .= '		</div>'; //.row
				$output .= '	</div>'; //.vc_col-xs-12
				
			}
			$output .= '	<input name="' . $settings['param_name'] . '" class="wpb_vc_param_value  ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" />';
			$output .= '</div>'; // .liquid-shape-divider-container

			return $output;

		}

		public static function get_shape_divider_values( $value ) {
			return vc_parse_multi_attribute( $value, array( 'top_shape_type' => '', 'top_shape_color' => '', 'top_shape_height' => '', 'top_shape_bringtofront' => '', 'top_shape_flip' => '', 'top_shape_inverse' => '', 'bottom_shape_type' => '', 'bottom_shape_color' => '', 'bottom_shape_height' => '', 'bottom_shape_bringtofront' => '', 'bottom_shape_flip' => '', 'bottom_shape_inverse' => '' ) );
		}

		/**
		 * @return string
		 */
		function getShapeTypeOptions( $position, $values = array() ) {
			$output = '<option data-svg-path="" value="">' . esc_html__( 'None', 'landinghub-core' ) . '</option>';
			$styles = apply_filters( 'liquid_shape_divider_type_options_data', array(
				'1',
				'2',
				'3',
				'4',
				'5',
				'6',
				'7',
				'8',
				'9',
				'10',
				'11',
				'12',
				'13',
				'14',
			) );
			$selected = '';

			foreach ( $styles as $key => $style ) {
				
				$selected = '';
				if( $style === $values[ $position . '_shape_type'] ) {
					$selected = 'selected';
				}  	
				$output .= '<option ' . $selected . ' data-svg-path="' . get_template_directory_uri() . '/assets/img/svg-divider/' . $style . '.svg' . '" value="' . $style . '">' . $style  . '</option>';
			}
			

			return $output;
		}


		function getShapeColor( $position, $values = array() ) {

			$output = '<input type="text" data-name="' . $position . '-shape-color" name="' . $position . '_shape_color" value="' . $values[ $position . '_shape_color' ] . '" class="liquid_color-control">';

			return $output;

		}

		function getShapeHeight( $position, $values = array() ) {

			return '<div class="liquid-slider"><div class="liquid-handle ui-slider-handle"></div></div><input type="hidden" data-name="' . $position . '-shape-height" name="' . $position . '_shape_height" value="' . $values[ $position . '_shape_height' ] . '" class="liquid_shape_height-control liquid-sliderinput" >';

		}

		function shapeBringToFront( $position, $values = array() ) {

			return '<label class="vc_checkbox-nolabel"><input type="checkbox" data-name="' . $position . '-shape-bringtofront-checkbox" name="' . $position . '_shape_bringtofront_checkbox"><span class="checkbox"></span> <span>Bring to front</span></label><input type="hidden" data-name="' . $position . '-shape-bringtofront" name="' . $position . '_shape_bringtofront" value="' . $values[ $position . '_shape_bringtofront' ] . '">';

		}

		function getTopShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'top_shape_type' ] . '.svg' );
		}

		function getBottomShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'bottom_shape_type' ] . '.svg' );
		}


		public static function getShape( $value, $pos = 'top' ) {

			if( empty( $value ) ){
				return;
			}

			$values = Liquid_Shape_Divider_Options::get_shape_divider_values( $value );
			if( ! isset( $values[ $pos . '_shape_type' ] ) || empty( $values[ $pos . '_shape_type' ] ) ) {
				return;
			}

			$shape = $values[ $pos . '_shape_type' ];
			$bring_to_front = !empty($values[$pos . '_shape_bringtofront']) ? 'z-index-99' : '';
			$svg = '';

			switch( $shape ) {

				case '1':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1943" height="98.812" viewBox="0 0 1943 98.812" preserveAspectRatio="none">
										<path d="M0,0Q199.075,74.109,485.75,74.109C806.262,74.109,1214.291,0,1578.6,0H1943V98.812H0" />
									</svg>';
					break;
					
				case '2':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100" viewBox="0 0 100 100" preserveAspectRatio="none">
								<path d="M0 100 C40 0 60 0 100 100 Z"/>
							</svg>';
					break;
					
				case '3':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1200" height="120" viewBox="0 0 1200 120" preserveAspectRatio="none">
							<path d="M1200 120 1200 0 0 120z"/>
						</svg>';
					break;
					
				case '4':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="100%" height="182" viewBox="0 0 1920 182" preserveAspectRatio="none">
						<path d="M1921.91,916.348c0.33,39.216-.34,79.431,0,118.642Q957.95,1035.5-6,1035V853c40.431,10.8,81,19.794,122.5,27.149,62.957,11.157,117.371,15.375,180.742,21.116,79.864,7.236,165.843,26.989,255.045,42.232,109.142,18.65,243.949,40.091,308.265,44.243,137.637,8.886,313.056-2.783,504.066-36.2,127.4-22.286,223.4-43.261,354.45-45.248A1569.414,1569.414,0,0,1,1921.91,916.348Z" transform="translate(0 -853)"/>
					</svg>';
					break;
					
				case '5':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '300';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1920.002" height="855.001" viewBox="0 0 1920.002 855.001" preserveAspectRatio="none">
										<g transform="translate(-0.999 -1)">
											<path
												d="M-5389.008,1191h-1920v-143.71c15.768,7.3,31.861,14.19,47.834,20.492,15.7,6.2,31.732,11.992,47.64,17.228,15.632,5.146,31.6,9.9,47.458,14.128,15.569,4.152,31.478,7.918,47.284,11.192,15.5,3.211,31.354,6.044,47.122,8.42,15.442,2.326,31.246,4.281,46.971,5.81,15.377,1.5,31.133,2.628,46.83,3.365,15.307.719,31,1.084,46.655,1.084h.046c24.472,0,49.8-.9,75.28-2.658,24.288-1.68,49.522-4.205,75-7.505,24.088-3.12,49.242-7.044,74.763-11.661,23.853-4.316,48.939-9.4,74.564-15.124,23.864-5.327,48.2-11.18,74.405-17.894,23.335-5.979,47.634-12.512,74.287-19.972,49.481-13.85,99.739-28.871,148.341-43.4l.037-.011,9.906-2.961c41.811-11.991,82.8-23.679,124.588-34.832,46.448-12.4,87.494-22.389,125.485-30.546,21.65-4.649,42.908-8.824,63.183-12.41,21.637-3.827,43.012-7.134,63.531-9.831,21.668-2.848,43.175-5.118,63.923-6.75,21.739-1.709,43.391-2.774,64.354-3.166,12.5-.456,25.326-.687,38.111-.687,15.889,0,32.233.357,48.579,1.062,15.944.687,32.356,1.726,48.783,3.086,31.507,2.61,64.492,6.527,98.04,11.642,31.5,4.8,64.621,10.836,98.439,17.929,31.31,6.567,64.47,14.308,98.56,23.009V1191Z"
												transform="translate(7310.009 -334.996)"  fill-opacity="0.45" />
											<path
												d="M-5483,1034H-7403V881.554c18.207,11.395,36.9,22.133,55.547,31.915,18.248,9.571,36.987,18.5,55.7,26.548,18.288,7.862,37.075,15.1,55.839,21.522,18.313,6.264,37.144,11.93,55.971,16.84,18.334,4.782,37.207,8.987,56.093,12.5,18.352,3.414,37.262,6.275,56.207,8.5,18.358,2.16,37.3,3.792,56.312,4.851,18.355,1.022,37.333,1.541,56.406,1.54,19.793,0,40.336-.56,61.058-1.662,19.754-1.051,40.327-2.63,61.146-4.694,38.427-3.81,78.5-9.29,122.508-16.753,36.671-6.219,76.812-13.966,122.715-23.685,40.92-8.664,82.544-18.06,122.8-27.146l.022-.005,1.145-.259,8.509-1.92c74.68-15.947,142.084-30.023,210.75-40.789,37.854-5.935,72.5-10.3,105.924-13.33,18.039-1.638,35.9-2.891,53.092-3.724,18.008-.873,35.9-1.316,53.175-1.316,20.952,0,41.757.651,61.837,1.936,19.93.9,40.466,2.5,61.038,4.746,19.924,2.179,40.48,5.036,61.1,8.491,19.9,3.336,40.462,7.33,61.106,11.871,19.854,4.368,40.4,9.377,61.068,14.889,19.783,5.275,40.3,11.177,60.983,17.542,19.676,6.055,40.148,12.727,60.85,19.831,38.048,13.058,77.663,27.8,121.108,45.076V1034Zm0-39.362h0q-.048-24.324-.1-49.51l-.023-11.113v-.088c-.271-128.228-.578-273.565-.717-419.218-.125-113.67-.146-228.525-.151-335.711h1Z"
												transform="translate(7404 -178)" opacity="0.36" />
											<path
												d="M-5404.415,1119.764H-6935.756c22.308-.49,45.409-1.8,68.662-3.888,22.154-1.992,45.176-4.761,68.425-8.231,21.979-3.28,44.933-7.3,68.223-11.953,21.768-4.347,44.665-9.413,68.054-15.055,21.788-5.256,44-10.992,67.92-17.537,21.3-5.83,43.487-12.175,67.819-19.4,45.18-13.413,91.07-27.891,135.45-41.892l.021-.007,4.562-1.439,4.805-1.516c39.6-11.988,78.414-23.671,117.988-34.821,43.98-12.392,82.853-22.38,118.837-30.536,20.506-4.648,40.637-8.821,59.835-12.406,20.5-3.826,40.738-7.133,60.167-9.828,20.517-2.846,40.884-5.117,60.536-6.748,20.588-1.709,41.094-2.773,60.945-3.165,11.843-.456,23.984-.687,36.085-.687,18.549,0,37.695.543,56.905,1.614,18.623,1.038,37.864,2.6,57.187,4.651,18.678,1.98,37.992,4.471,57.407,7.4,18.7,2.825,38.068,6.147,57.566,9.873,18.692,3.572,38.093,7.629,57.663,12.056,18.653,4.22,38.066,8.915,57.7,13.955,36.282,9.313,73.984,19.933,115.26,32.468a537.165,537.165,0,0,1-1.414-63.556c.638-19.879,2.185-41.528,4.731-66.186v266.826Zm-1572.31,0h-347.689V1033.17c14.512,7.331,29.323,14.288,44.022,20.677,14.453,6.282,29.2,12.191,43.845,17.562,14.392,5.28,29.088,10.191,43.68,14.6,14.333,4.328,28.976,8.292,43.521,11.782,14.274,3.425,28.868,6.492,43.374,9.117,14.22,2.572,28.767,4.794,43.237,6.6,14.167,1.77,28.67,3.2,43.106,4.236,14.089,1.016,28.524,1.695,42.9,2.018Z"
												transform="translate(7325.415 -263.762)" />
										</g>
									</svg>';
				break;
					
				case '6':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 68" preserveAspectRatio="none">
									<path d="m1622.3 1937.7c0 0-410.7 169.1-913.4 75.5-502.7-93.6-977.7 56.3-977.7 56.3v440h1891.1v-571.8" transform="translate(0-1977)"></path>
								</svg>';
				break;
				case '7':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="9" viewBox="0 0 1440 9" preserveAspectRatio="none">
							  <path d="M1379,9.92687204e-05 C1380.76992,9.92687204e-05 1382.53969,0.677111942 1383.8855,2.03074021 L1386.94548,5.11740181 C1389.63201,7.8270408 1394.03086,7.8270408 1396.71693,5.11740181 L1399.77999,2.03074021 C1402.46652,-0.676913405 1406.86276,-0.676913405 1409.54883,2.03074021 L1412.61389,5.11740181 C1415.29842,7.8270408 1419.69712,7.8270408 1422.38334,5.11740181 L1425.44594,2.03074021 C1428.13493,-0.676913405 1432.53179,-0.676913405 1435.21785,2.03074021 L1438.28045,5.11978426 C1440.96991,7.82743787 1445.36599,7.82743787 1448.05221,5.11978426 L1451.11527,2.03074021 C1453.80196,-0.676913405 1458.19758,-0.676913405 1460.88704,2.03074021 L1463.94732,5.11740181 C1466.63324,7.8270408 1471.03225,7.8270408 1473.71862,5.11740181 L1476.78153,2.03074021 C1479.46775,-0.676913405 1483.86445,-0.676913405 1486.55314,2.03074021 L1489.61343,5.11740181 C1492.30227,7.8270408 1496.69866,7.8270408 1499.38488,5.11740181 L1502.44779,2.03074021 C1505.13416,-0.676913405 1509.53025,-0.676913405 1512.21724,2.03074021 L1515.2803,5.11740181 C1517.96667,7.8270408 1522.36291,7.8270408 1525.05175,5.11740181 L1528.11435,2.03074021 C1529.45754,0.675920717 1531.22962,-0.00228318057 1533,9.92687204e-05 L1533,9 L1379,9 L1226,9 L1073,9 L919,9 L766,9 L613,9 L460,9 L307,9 L154,9 L0,9 L0,9.92687204e-05 C1.769922,9.92687204e-05 3.53969,0.677111942 4.885496,2.03074021 L7.945476,5.11740181 C10.632006,7.8270408 15.030862,7.8270408 17.71693,5.11740181 L20.77999,2.03074021 C23.46652,-0.676913405 27.862758,-0.676913405 30.548826,2.03074021 L33.613888,5.11740181 C36.298416,7.8270408 40.697118,7.8270408 43.38334,5.11740181 L46.445938,2.03074021 C49.134932,-0.676913405 53.531786,-0.676913405 56.217854,2.03074021 L59.280452,5.11978426 C61.969908,7.82743787 66.365992,7.82743787 69.052214,5.11978426 L72.115274,2.03074021 C74.801958,-0.676913405 79.19758,-0.676913405 81.887036,2.03074021 L84.947324,5.11740181 C87.633238,7.8270408 92.032248,7.8270408 94.718624,5.11740181 L97.78153,2.03074021 C100.467752,-0.676913405 104.864452,-0.676913405 107.553138,2.03074021 L110.613426,5.11740181 C113.302266,7.8270408 117.698658,7.8270408 120.38488,5.11740181 L123.447786,2.03074021 C126.134162,-0.676913405 130.530246,-0.676913405 133.217238,2.03074021 L136.280298,5.11740181 C138.966674,7.8270408 143.362912,7.8270408 146.051752,5.11740181 L149.11435,2.03074021 C150.203951,0.93170321 151.575786,0.277916034 153,0.0714983408 L153,9.92687204e-05 C153.165404,9.92687204e-05 153.330806,0.00601187356 153.495861,0.0178367592 C153.663677,0.0057866107 153.831846,-0.000127020259 154,9.92687204e-05 L154,0.0725499097 C155.423321,0.279975174 156.793877,0.93277591 157.885496,2.03074021 L160.945476,5.11740181 C163.632006,7.8270408 168.030862,7.8270408 170.71693,5.11740181 L173.77999,2.03074021 C176.46652,-0.676913405 180.862758,-0.676913405 183.548826,2.03074021 L186.613888,5.11740181 C189.298416,7.8270408 193.697118,7.8270408 196.38334,5.11740181 L199.445938,2.03074021 C202.134932,-0.676913405 206.531786,-0.676913405 209.217854,2.03074021 L212.280452,5.11978426 C214.969908,7.82743787 219.365992,7.82743787 222.052214,5.11978426 L225.115274,2.03074021 C227.801958,-0.676913405 232.19758,-0.676913405 234.887036,2.03074021 L237.947324,5.11740181 C240.633238,7.8270408 245.032248,7.8270408 247.718624,5.11740181 L250.78153,2.03074021 C253.467752,-0.676913405 257.864452,-0.676913405 260.553138,2.03074021 L263.613426,5.11740181 C266.302266,7.8270408 270.698658,7.8270408 273.38488,5.11740181 L276.447786,2.03074021 C279.134162,-0.676913405 283.530246,-0.676913405 286.217238,2.03074021 L289.280298,5.11740181 C291.966674,7.8270408 296.362912,7.8270408 299.051752,5.11740181 L302.11435,2.03074021 C303.203951,0.93170321 304.575786,0.277916034 306,0.0714983408 L306,9.92687204e-05 C306.165404,9.92687204e-05 306.330806,0.00601187356 306.495861,0.0178367592 C306.663677,0.0057866107 306.831846,-0.000127020259 307,9.92687204e-05 L307,0.0725499097 C308.423321,0.279975174 309.793877,0.93277591 310.885496,2.03074021 L313.945476,5.11740181 C316.632006,7.8270408 321.030862,7.8270408 323.71693,5.11740181 L326.77999,2.03074021 C329.46652,-0.676913405 333.862758,-0.676913405 336.548826,2.03074021 L339.613888,5.11740181 C342.298416,7.8270408 346.697118,7.8270408 349.38334,5.11740181 L352.445938,2.03074021 C355.134932,-0.676913405 359.531786,-0.676913405 362.217854,2.03074021 L365.280452,5.11978426 C367.969908,7.82743787 372.365992,7.82743787 375.052214,5.11978426 L378.115274,2.03074021 C380.801958,-0.676913405 385.19758,-0.676913405 387.887036,2.03074021 L390.947324,5.11740181 C393.633238,7.8270408 398.032248,7.8270408 400.718624,5.11740181 L403.78153,2.03074021 C406.467752,-0.676913405 410.864452,-0.676913405 413.553138,2.03074021 L416.613426,5.11740181 C419.302266,7.8270408 423.698658,7.8270408 426.38488,5.11740181 L429.447786,2.03074021 C432.134162,-0.676913405 436.530246,-0.676913405 439.217238,2.03074021 L442.280298,5.11740181 C444.966674,7.8270408 449.362912,7.8270408 452.051752,5.11740181 L455.11435,2.03074021 C456.203951,0.93170321 457.575786,0.277916034 459,0.0714983408 L459,9.92687204e-05 C459.165404,9.92687204e-05 459.330806,0.00601187356 459.495861,0.0178367592 C459.663677,0.0057866107 459.831846,-0.000127020259 460,9.92687204e-05 L460,0.0725499097 C461.423321,0.279975174 462.793877,0.93277591 463.885496,2.03074021 L466.945476,5.11740181 C469.632006,7.8270408 474.030862,7.8270408 476.71693,5.11740181 L479.77999,2.03074021 C482.46652,-0.676913405 486.862758,-0.676913405 489.548826,2.03074021 L492.613888,5.11740181 C495.298416,7.8270408 499.697118,7.8270408 502.38334,5.11740181 L505.445938,2.03074021 C508.134932,-0.676913405 512.531786,-0.676913405 515.217854,2.03074021 L518.280452,5.11978426 C520.969908,7.82743787 525.365992,7.82743787 528.052214,5.11978426 L531.115274,2.03074021 C533.801958,-0.676913405 538.19758,-0.676913405 540.887036,2.03074021 L543.947324,5.11740181 C546.633238,7.8270408 551.032248,7.8270408 553.718624,5.11740181 L556.78153,2.03074021 C559.467752,-0.676913405 563.864452,-0.676913405 566.553138,2.03074021 L569.613426,5.11740181 C572.302266,7.8270408 576.698658,7.8270408 579.38488,5.11740181 L582.447786,2.03074021 C585.134162,-0.676913405 589.530246,-0.676913405 592.217238,2.03074021 L595.280298,5.11740181 C597.966674,7.8270408 602.362912,7.8270408 605.051752,5.11740181 L608.11435,2.03074021 C609.203951,0.93170321 610.575786,0.277916034 612,0.0714983408 L612,9.92687204e-05 C612.165404,9.92687204e-05 612.330806,0.00601187356 612.495861,0.0178367592 C612.663677,0.0057866107 612.831846,-0.000127020259 613,9.92687204e-05 L613,0.0725499097 C614.423321,0.279975174 615.793877,0.93277591 616.885496,2.03074021 L619.945476,5.11740181 C622.632006,7.8270408 627.030862,7.8270408 629.71693,5.11740181 L632.77999,2.03074021 C635.46652,-0.676913405 639.862758,-0.676913405 642.548826,2.03074021 L645.613888,5.11740181 C648.298416,7.8270408 652.697118,7.8270408 655.38334,5.11740181 L658.445938,2.03074021 C661.134932,-0.676913405 665.531786,-0.676913405 668.217854,2.03074021 L671.280452,5.11978426 C673.969908,7.82743787 678.365992,7.82743787 681.052214,5.11978426 L684.115274,2.03074021 C686.801958,-0.676913405 691.19758,-0.676913405 693.887036,2.03074021 L696.947324,5.11740181 C699.633238,7.8270408 704.032248,7.8270408 706.718624,5.11740181 L709.78153,2.03074021 C712.467752,-0.676913405 716.864452,-0.676913405 719.553138,2.03074021 L722.613426,5.11740181 C725.302266,7.8270408 729.698658,7.8270408 732.38488,5.11740181 L735.447786,2.03074021 C738.134162,-0.676913405 742.530246,-0.676913405 745.217238,2.03074021 L748.280298,5.11740181 C750.966674,7.8270408 755.362912,7.8270408 758.051752,5.11740181 L761.11435,2.03074021 C762.203951,0.93170321 763.575786,0.277916034 765,0.0714983408 L765,9.92687204e-05 C765.165404,9.92687204e-05 765.330806,0.00601187356 765.495861,0.0178367592 C765.663677,0.0057866107 765.831846,-0.000127020259 766,9.92687204e-05 L766,0.0725499097 C767.423321,0.279975174 768.793877,0.93277591 769.885496,2.03074021 L772.945476,5.11740181 C775.632006,7.8270408 780.030862,7.8270408 782.71693,5.11740181 L785.77999,2.03074021 C788.46652,-0.676913405 792.862758,-0.676913405 795.548826,2.03074021 L798.613888,5.11740181 C801.298416,7.8270408 805.697118,7.8270408 808.38334,5.11740181 L811.445938,2.03074021 C814.134932,-0.676913405 818.531786,-0.676913405 821.217854,2.03074021 L824.280452,5.11978426 C826.969908,7.82743787 831.365992,7.82743787 834.052214,5.11978426 L837.115274,2.03074021 C839.801958,-0.676913405 844.19758,-0.676913405 846.887036,2.03074021 L849.947324,5.11740181 C852.633238,7.8270408 857.032248,7.8270408 859.718624,5.11740181 L862.78153,2.03074021 C865.467752,-0.676913405 869.864452,-0.676913405 872.553138,2.03074021 L875.613426,5.11740181 C878.302266,7.8270408 882.698658,7.8270408 885.38488,5.11740181 L888.447786,2.03074021 C891.134162,-0.676913405 895.530246,-0.676913405 898.217238,2.03074021 L901.280298,5.11740181 C903.966674,7.8270408 908.362912,7.8270408 911.051752,5.11740181 L914.11435,2.03074021 C915.457538,0.675920717 917.229616,-0.00228318057 919,9.92687204e-05 C920.769922,9.92687204e-05 922.53969,0.677111942 923.885496,2.03074021 L926.945476,5.11740181 C929.632006,7.8270408 934.030862,7.8270408 936.71693,5.11740181 L939.77999,2.03074021 C942.46652,-0.676913405 946.862758,-0.676913405 949.548826,2.03074021 L952.613888,5.11740181 C955.298416,7.8270408 959.697118,7.8270408 962.38334,5.11740181 L965.445938,2.03074021 C968.134932,-0.676913405 972.531786,-0.676913405 975.217854,2.03074021 L978.280452,5.11978426 C980.969908,7.82743787 985.365992,7.82743787 988.052214,5.11978426 L991.115274,2.03074021 C993.801958,-0.676913405 998.19758,-0.676913405 1000.88704,2.03074021 L1003.94732,5.11740181 C1006.63324,7.8270408 1011.03225,7.8270408 1013.71862,5.11740181 L1016.78153,2.03074021 C1019.46775,-0.676913405 1023.86445,-0.676913405 1026.55314,2.03074021 L1029.61343,5.11740181 C1032.30227,7.8270408 1036.69866,7.8270408 1039.38488,5.11740181 L1042.44779,2.03074021 C1045.13416,-0.676913405 1049.53025,-0.676913405 1052.21724,2.03074021 L1055.2803,5.11740181 C1057.96667,7.8270408 1062.36291,7.8270408 1065.05175,5.11740181 L1068.11435,2.03074021 C1069.20395,0.93170321 1070.57579,0.277916034 1072,0.0714983408 L1072,9.92687204e-05 C1072.1654,9.92687204e-05 1072.33081,0.00601187356 1072.49586,0.0178367592 C1072.66368,0.0057866107 1072.83185,-0.000127020259 1073,9.92687204e-05 L1073,0.0725499097 C1074.42332,0.279975174 1075.79388,0.93277591 1076.8855,2.03074021 L1079.94548,5.11740181 C1082.63201,7.8270408 1087.03086,7.8270408 1089.71693,5.11740181 L1092.77999,2.03074021 C1095.46652,-0.676913405 1099.86276,-0.676913405 1102.54883,2.03074021 L1105.61389,5.11740181 C1108.29842,7.8270408 1112.69712,7.8270408 1115.38334,5.11740181 L1118.44594,2.03074021 C1121.13493,-0.676913405 1125.53179,-0.676913405 1128.21785,2.03074021 L1131.28045,5.11978426 C1133.96991,7.82743787 1138.36599,7.82743787 1141.05221,5.11978426 L1144.11527,2.03074021 C1146.80196,-0.676913405 1151.19758,-0.676913405 1153.88704,2.03074021 L1156.94732,5.11740181 C1159.63324,7.8270408 1164.03225,7.8270408 1166.71862,5.11740181 L1169.78153,2.03074021 C1172.46775,-0.676913405 1176.86445,-0.676913405 1179.55314,2.03074021 L1182.61343,5.11740181 C1185.30227,7.8270408 1189.69866,7.8270408 1192.38488,5.11740181 L1195.44779,2.03074021 C1198.13416,-0.676913405 1202.53025,-0.676913405 1205.21724,2.03074021 L1208.2803,5.11740181 C1210.96667,7.8270408 1215.36291,7.8270408 1218.05175,5.11740181 L1221.11435,2.03074021 C1222.20395,0.93170321 1223.57579,0.277916034 1225,0.0714983408 L1225,9.92687204e-05 C1225.1654,9.92687204e-05 1225.33081,0.00601187356 1225.49586,0.0178367592 C1225.66368,0.0057866107 1225.83185,-0.000127020259 1226,9.92687204e-05 L1226,0.0725499097 C1227.42332,0.279975174 1228.79388,0.93277591 1229.8855,2.03074021 L1232.94548,5.11740181 C1235.63201,7.8270408 1240.03086,7.8270408 1242.71693,5.11740181 L1245.77999,2.03074021 C1248.46652,-0.676913405 1252.86276,-0.676913405 1255.54883,2.03074021 L1258.61389,5.11740181 C1261.29842,7.8270408 1265.69712,7.8270408 1268.38334,5.11740181 L1271.44594,2.03074021 C1274.13493,-0.676913405 1278.53179,-0.676913405 1281.21785,2.03074021 L1284.28045,5.11978426 C1286.96991,7.82743787 1291.36599,7.82743787 1294.05221,5.11978426 L1297.11527,2.03074021 C1299.80196,-0.676913405 1304.19758,-0.676913405 1306.88704,2.03074021 L1309.94732,5.11740181 C1312.63324,7.8270408 1317.03225,7.8270408 1319.71862,5.11740181 L1322.78153,2.03074021 C1325.46775,-0.676913405 1329.86445,-0.676913405 1332.55314,2.03074021 L1335.61343,5.11740181 C1338.30227,7.8270408 1342.69866,7.8270408 1345.38488,5.11740181 L1348.44779,2.03074021 C1351.13416,-0.676913405 1355.53025,-0.676913405 1358.21724,2.03074021 L1361.2803,5.11740181 C1363.96667,7.8270408 1368.36291,7.8270408 1371.05175,5.11740181 L1374.11435,2.03074021 C1375.45754,0.675920717 1377.22962,-0.00228318057 1379,9.92687204e-05 Z"/>
					</svg>';
				break;
				case '8':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '100';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="100" viewBox="0 0 1440 100" preserveAspectRatio="none">
								<path id="Row_Separator" data-name="Row Separator" d="M1440,0Q1080,99,720,99T0,0V100H1440Z" />
							</svg>';
				break;
				case '9':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '32';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="32" viewBox="0 0 1440 32" preserveAspectRatio="none">
								<path d="M1415.788,8.243 C1414.85832,8.4679854 1413.88421,8.4281481 1412.976,8.128 C1411.44,7.776 1409.913,7.428 1408.33,9.415 C1406.73,10.623 1405.172,10.544 1403.597,10.472 C1402.68536,10.3824791 1401.76573,10.4188199 1400.864,10.58 C1399.635,9.911 1398.399,9.048 1397.108,9.89 C1396.391,11.58 1395.714,11.213 1395.037,10.846 C1394.454,10.53 1393.864,10.213 1393.237,11.22 C1390.67,10.314 1388.244,11.155 1385.992,11.27 C1383.716,12.456 1381.613,12.708 1379.676,11.191 C1377.739,9.674 1375.876,10.407 1374.076,11.759 C1372.399,8.307 1370.682,10.63 1369.076,10.731 C1368.163,12.241 1367.32,11.795 1366.485,11.349 C1365.792,10.982 1365.107,10.608 1364.406,11.371 C1363.5557,11.2641116 1362.69508,11.2688181 1361.846,11.385 C1361.25269,11.455217 1360.6554,11.4862843 1360.058,11.478 C1358.034,11.399 1357.412,9.522 1356.538,13.218 C1352.12,11.801 1327.186,4.007 1325.674,5.035 C1324.174,5.459 1306.111,3.467 1304.111,3.302 C1303.08157,3.79409931 1301.88925,3.81526043 1300.843,3.36 C1300.1391,3.07695231 1299.37284,2.98518042 1298.622,3.094 C1297.0509,2.40157365 1295.28095,2.30697745 1293.645,2.828 C1292.54641,3.19304431 1291.36575,3.23297825 1290.245,2.943 C1289.09933,2.41883216 1288.01648,1.76704077 1287.017,1 C1285.977,1.978 1285.032,1.367 1284.087,2.51 C1282.187,4.466 1267.454,5.552 1265.611,4.998 C1263.752,5.53 1253.294,12.764 1250.963,12.298 C1249.837,10.069 1225.447,8.149 1224.053,8.228 C1222.691,7.056 1221.202,6.035 1219.485,8.465 C1217.12699,8.49815884 1214.7806,8.80215252 1212.492,9.371 C1211.35,9.723 1211.2,10.071 1211.374,10.263 C1211.658,13.269 1213.335,11.392 1211.012,10.982 C1210.689,11.126 1210.303,10.853 1209.831,10.582 C1209.02921,9.96377523 1207.89884,10.0123164 1207.153,10.697 C1206.34028,10.5496435 1205.50553,10.5765708 1204.704,10.776 C1202.93542,11.2063029 1201.06944,10.9493328 1199.483,10.057 C1197.262,10.165 1195.364,11.502 1193.828,10.388 C1192.237,11.129 1191.009,9.101 1189.985,9.036 C1187.851,12.2 1186.772,10.836 1186.221,7.763 C1185.536,6.713 1185.481,6.756 1185.37,6.799 C1185.291,6.835 1185.181,6.864 1184.77,6.468 C1184.479,7.784 1184.124,7.18 1183.57,6.576 C1183.07,6.03 1182.42,5.476 1181.53,6.396 C1180.971,4.066 1180.246,4.677 1179.404,5.289 C1179.04318,5.61944872 1178.57777,5.81269138 1178.089,5.835 C1176.679,5.957 1174.955,6.914 1172.907,7.82 C1172.09523,8.19913972 1171.17097,8.26085158 1170.316,7.993 C1169.253,7.777 1168.229,7.569 1167.216,8.762 C1165.468,8.999 1163.798,11.947 1162.357,9.503 C1160.869,9.203 1159.53,7.475 1158.215,8.633 C1157.81081,9.1373972 1157.13536,9.33688054 1156.522,9.133 C1155.876,9.033 1155.262,8.924 1154.64,10.104 C1154.065,11.197 1150.498,10.615 1147.24,10.032 C1145.64869,9.69131803 1144.03537,9.46308719 1142.412,9.349 C1139.15133,9.39966667 1135.89367,9.45233333 1132.639,9.507 C1130.599,9.536 1126.539,9.212 1121.881,8.889 C1112.627,8.249 1101.058,7.609 1098.467,9.745 C1096.593,11.291 1096.412,10.27 1096.278,9.932 C1096.144,9.817 1096.105,8.472 1094.506,10.378 C1092.955,9.918 1089.978,6.322 1083.806,10.105 C1082.07174,8.9615439 1080.04704,8.33706411 1077.97,8.305 C1075.96909,8.37769635 1074.04679,9.10250849 1072.496,10.369 C1068.976,12.159 1065.786,11.347 1062.88,8.869 C1061.6508,8.97817426 1060.42006,8.6771693 1059.38,8.013 C1057.773,7.229 1056.238,6.438 1054.726,7.984 C1049.166,4.856 1025.398,6.014 1021.169,8.991 C1020.153,9.703 1019.137,11.723 1018.2,10.868 C1017.263,10.235 1016.31,11.436 1015.4,12.177 C1014.518,11.444 1013.644,11.882 1012.84,10.638 C1012.04,11.472 1011.856,10.667 1012.068,9.869 C1012.312,8.969 1013.06,8.069 1014.005,9.509 C1014.94536,9.21192283 1015.94686,9.16470857 1016.911,9.372 C1018.06926,9.65437281 1019.29036,9.51246712 1020.353,8.972 C1022.18,7.778 1023.07,8.26 1021.282,9.403 C1020.361,11.057 1018.801,11.733 1016.407,9.669 C1014.93358,9.73576989 1013.46094,9.52093224 1012.068,9.036 C1010.383,8.597 1008.461,7.965 1006.224,8.856 C1003.279,8.173 1000.955,9.704 999.191,9.971 C997.88743,9.8607981 996.613378,9.52231449 995.427,8.971 C995.028245,8.82720588 994.583812,8.89494337 994.246,9.151 C993.946,9.41 994.12,9.676 994.569,8.669 C995.026,6.728 995.669,7.36 996.333,7.993 C996.774,8.41 997.223,8.834 997.64,8.493 C997.792547,8.6517684 998.01012,8.73078077 998.228998,8.70689609 C998.447875,8.68301142 998.643287,8.55893274 998.758,8.371 C999.002,8.071 999.034,7.771 998.679,8.364 C998.041,7.156 996.033,8.501 991.725,8.522 C988.089362,8.39210889 984.493155,7.72314897 981.054,6.537 C975.84,4.984 971.254,3.423 967.941,5.703 C965.878,7.127 963.964,6.314 962.16,5.473 C960.371348,6.15442802 958.422774,6.29934603 956.553,5.89 C955.193881,5.59160822 953.784178,5.61145836 952.434,5.948 C951.667058,6.3978646 950.770151,6.57414349 949.89,6.448 C949.120515,6.31890583 948.330067,6.46024644 947.653,6.848 C946.818,7.696 946.038,7.265 945.298,6.841 C944.715,6.496 944.148,6.158 943.589,6.453 C941.1,6.553 908.52,4.698 906.803,2.534 C905.078,0.485 912.875,8.869 911.623,9.07 C909.15,7.891 907.488,8.063 905.811,8.876 C902.488,8.761 902.503,8.107 901.936,8.376 C901.652,8.901 901.243,8.585 900.236,6.916 C898.423653,6.42318619 896.499116,6.54450267 894.763,7.261 C891.999,6.815 890.487,6.427 889.62,6.42 C888.72,7.901 888.573,5.047 888.431,5.011 C888.297,4.86 888.231,5.061 887.667,5.263 C886.380612,5.61880841 885.033685,5.69956267 883.714,5.5 C882.214,6.895 880.863,6.593 879.564,6.737 C878.903,7.337 875.918,5.63 872.957,3.918 C870.027,2.235 867.129,0.546 866.499,1.085 C865.543851,2.18758653 863.892468,2.3489008 862.742,1.452 C861.411,3.242 855.568,6.112 854.055,7.967 C852.555,8.945 850.936,10.067 849.18,8.729 C848.232908,8.98358088 847.232651,8.9610213 846.298,8.664 C845.291736,8.38471761 844.233229,8.35042842 843.211,8.564 C836.572,8.111 836.044,6.939 835.769,6.996 C835.493,6.737 835.509,5.939 829.949,6.809 C826.822,5.22 827.256,5.687 828.728,6.155 C830.005306,6.65441112 831.412345,6.71526556 832.728,6.328 C833.140211,6.34763214 833.54883,6.24312607 833.901,6.028 C834.301,5.755 834.177,5.489 833.082,6.057 C831.342,6.474 827.191,6.273 818.875,6.891 C816.38616,7.61559321 813.773672,7.81380312 811.204,7.473 C809.251,7.308 807.558,7.149 806.085,7.782 C802.985,7.12 800.879,7.94 799.399,8.034 C796.43,8.897 795.942,8.717 794.666,8.58 C794.296,9.011 787.247,9.004 779.9,9.004 C772.607,9.004 765.015,9.004 763.346,9.414 C761.610951,9.97110096 759.775005,10.1417596 757.967,9.914 C756.227,9.547 740.184,9.964 737.231,14.624 C732.592,12.711 695.405,13.373 696.696,14.336 C694.782,12.905 693.302,14.674 692.196,14.904 C691.149,15.357 690.456,13.272 689.951,11.186 C689.376,8.806 689.045,6.426 688.722,7.828 C688.108,8.813 690.541,8.389 691.722,7.965 C692.746,7.598 692.832,7.232 689.233,7.765 C687.28,8.599 685.996,10.828 685.256,10.023 C684.5,10.339 684.193,13.023 684.279,10.152 C684.318,11.852 685.563,10.109 686.413,9.109 C685.736,9.909 677.207,9.792 668.772,9.684 C662.732,9.598 656.746,9.519 653.722,9.77 C652.58,8.008 647.697,7.879 646.169,9.57 C645.169,8.592 645.869,7.111 647.594,6.564 C633.426,7.064 633.552,8.923 619.376,9.426 C612.514738,9.63305486 605.647238,9.41463611 598.813,8.772 C593.613,8.11 594.592,8.118 596.08,8.118 C597.057,8.118 598.246,8.118 598.088,7.938 C599.317,9.347 599.947,8.866 597.655,7.305 C596.537,5.054 594.607,7.118 591.678,7.593 C591.040067,7.87146094 590.317505,7.88441525 589.67,7.629 C588.577023,7.21051493 587.341003,7.45367903 586.488,8.255 C585.554933,8.18572395 584.617398,8.20514433 583.688,8.313 C582.312204,8.47324077 580.920944,8.44430525 579.553,8.227 C576.053,8.083 572.843,7.803 569.898,7.673 C567.193584,7.48551633 564.47668,7.60123629 561.798,8.018 C559.463704,8.85001966 556.931975,8.95462214 554.537,8.318 C552.765,7.994 551.151,7.671 549.662,8.167 C530.737,11.885 514.041,5.167 496.117,4.421 C495.597,4.399 485.501,7.139 482.847,7.348 C480.431753,7.41846995 478.024382,7.04041093 475.747,6.233 C472.361,5.255 469.069,4.27 465.178,6.168 C462.17,5.974 460.201,6.283 458.862,5.14 C456.2,2.451 455.917,4.809 454.688,4.91 C454.088,3.587 453.231,3.853 451.68,4.5 C450.18,2.228 447.98,1.8 444.663,1.329 C441.738005,1.97370864 438.731989,2.16995108 435.748,1.911 C434.425,1.724 433.015,3.364 431.669,5.003 C430.323,6.642 429.062,8.275 428.023,8.103 C423.849,7.974 420.667,7.139 417.998,5.025 C416.762917,5.33124262 415.485927,5.43259102 414.218,5.325 C413.089344,5.20812695 411.948788,5.30308851 410.855,5.605 C408.918,7.295 409.209,7.151 410.115,7.005 C410.928679,6.78533437 411.797952,6.94084981 412.485,7.429 C413.336,6.084 413.729,7.681 412.685,7.853 C411.638,8.205 409.173,7.163 404.203,6.453 C402.507351,6.43243786 400.835547,6.8535766 399.352,7.675 C397.69,8.559 396.8,9.437 396.391,8.509 C395.674,8.2 396.312,7.186 396.73,7.035 C397.13,7.574 397.313,9.214 395.793,7.186 C394.273,5.122 390.957,4.734 384.287,7.208 C381.70781,6.58055568 379.019301,6.55113943 376.427,7.122 C374.482,4.792 373.048,7 372.033,8.186 C370.025,8.157 369.639,6.547 369.347,7.474 C369.071,7.201 368.93,7.674 367.473,7.905 C366.756,7.114 365.693,8.236 364.102,9.372 C363.315,10.292 362.417,9.645 361.369,8.998 C360.321,8.351 359.117,7.698 357.715,8.624 C355.855423,9.5272683 353.759179,9.82388358 351.722,9.472 C350.493448,9.27744528 349.238766,9.32397786 348.028,9.609 C345.169,13.765 342.822,10.191 340.735,10.062 C339.065478,9.54909729 337.27111,9.61963062 335.647,10.262 C333.922,10.78 332.447,11.297 331.147,10.046 C329.788861,10.2975652 328.396753,10.3050151 327.036,10.068 C326.201218,9.95093404 325.35892,9.89578354 324.516,9.903 C323.76,10.403 323.524,10.083 323.642,9.766 C323.784,9.366 324.453,8.975 325.342,10.082 C326.98,11.614 329.477,11.282 331.13,11.614 C331.624701,11.2651233 332.306712,11.3698102 332.674,11.851 C333.028,12.29 332.874,12.735 331.957,11.427 C330.319,9.752 326.184,9.601 317.876,10.14 C312.332,11.449 308.142,12.362 304.96,11.593 C303.377,9.774 302.015,10.407 300.849,11.039 C299.683,11.671 298.738,12.297 297.974,10.539 C294.8,9.065 294.06,8.82 292.831,9.065 C292.414,9.791 291.957,9.611 291.343,9.432 C290.990351,9.31492989 290.619172,9.26374445 290.248,9.281 C289.035,8.404 287.295,9.49 284.712,9.781 C282.822,6.991 281.074,10.996 279.577,11.974 C278.813,13.031 278.12,13.274 277.49,13.009 C276.836,14.145 276.269,12.309 275.75,11.003 C275.596668,11.2023315 275.329735,11.2757995 275.096,11.183 C274.796,11.111 274.513,11.039 274.23,11.909 C273.765,12.88 273.379,10.37 273.017,9.745 C272.277,8.745 271.631,11.334 271.143,11.478 C270.182,11.118 272.088,6.919 271.836,8.078 C271.726,7.366 271.136,8.732 270.536,10.099 C269.867,11.652 269.189,13.199 269.205,11.724 C269.205,11.976 269.705,10.976 270.119,9.984 C270.533,8.992 270.867,7.978 270.505,8.244 C270.229,8.244 269.552,9.689 268.749,11.144 C267.426,13.517 265.756,15.897 264.949,11.87 C263.531,13.603 257.026,13.639 254.971,15.724 C254.239,17.982 253.506,17.572 252.742,17.155 C252.431334,16.9441365 252.062337,16.8360609 251.687,16.846 C251.026,14.229 250.301,14.732 249.545,15.235 C249.033,15.573 248.513,15.904 247.993,15.293 C246.686,14.941 245.363,11.317 243.874,13.776 C243.205,13.076 242.504,13.79 241.787,14.509 C240.968,15.329 240.125,16.148 239.298,14.847 C238.398,22.009 237.652,17.817 236.841,17.055 C236.455,15.926 236.054,16.336 235.641,16.746 C235.192,17.185 234.741,17.63 234.326,16.146 C232.656,12.881 230.884,12.146 229.002,14.737 C227.529,13.169 224.482,13.205 221.268,13.237 C216.984,13.287 212.392,13.337 210.802,9.606 C210.416,12.554 202.171,13.496 200.233,10.806 C199.784,11.561 199.333,12.316 198.878,13.071 C192.743,10.95 190.978,4.262 188.01,8.217 L185.624,6.017 C180.891,7.11 171.11,8.577 167.07,6.628 C165.480346,5.92476342 163.715977,5.71571498 162.006,6.028 C160.321,6.244 158.643,6.682 156.981,6.761 C155.39,7.661 153.831,7.161 152.287,6.668 C150.61,6.122 148.956,5.575 147.31,6.862 C145.341,9.005 143.475,7.462 141.655,7.243 C139.867,5.388 138.119,5.287 136.434,7.049 C133.961,5.769 131.677,5.309 129.622,6.984 C128.606,7.077 127.614,9.594 126.74,8.71 C125.85,9.271 125.04,8.66 124.322,7.351 C121.345,9.781 119.644,9.861 119.676,7.495 C118.176,8.415 116.746,8.027 115.352,7.639 C113.974,7.265 112.643,6.884 111.336,7.747 C108.736,6.374 106.304,4.878 103.98,6.316 C101.886935,5.6876009 99.7219686,5.33002182 97.538,5.252 C96.4554897,4.76398544 95.2574227,4.59070411 94.081,4.752 C93.3769633,4.82007336 92.6669795,4.79350362 91.97,4.673 C90.1365859,4.4811641 88.2839688,4.73538433 86.57,5.414 C84.759,5.96 83.081,6.514 81.876,6.133 C80.387,3.487 76.056,3.969 72.418,4.45 C70.8271704,4.78883897 69.1933696,4.87857488 67.575,4.716 C64.4125176,3.9606856 61.1023419,4.09917219 58.014,5.116 C55.746,5.749 54.194,6.382 53.848,5.763 C52.289,5.274 50.674,4.483 49.013,4.763 C47.879,2.699 46.813,3.102 45.8,3.505 C45.4008822,3.70664856 44.9628635,3.81956458 44.516,3.836 C42.016,4.188 37.609,5.044 35.286,3.599 C33.152,4.843 23.986,5.591 23.851,5.454 L16.44,5.612 C5.631,4.676 2.725,4.266 0.347,5.611 C0.347,5.611 0.237,14.47 0.197,17.44 C0.094,25.867 0.11,24.565 0,33 L1440.00377,33 C1440.00377,33 1439.561,23.81 1439.781,14.621 C1439.812,13.305 1439.844,11.975 1439.875,10.637 C1439.906,9.271 1439.914,9.055 1439.985,6.301 C1440.064,2.821 1439.678,18.885 1439.678,18.913 C1439.778,14.469 1439.851,10.025 1439.796,5.582 C1432.681,6.272 1422.088,5.934 1415.788,8.243 Z" transform="translate(0 -1)"/>
							</svg>';
				break;
				case '10':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '75';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="74.662" viewBox="0 0 1440 74.662" preserveAspectRatio="none">
								<path d="M1440,74.662H.039L0,43.125s184.667,7.838,363.176-25.185C578.118-21.807,745.922,16.268,769.451,20.6c57.294,10.494,143.961,43.424,431.176,9.992C1308.2,16.305,1440,17.939,1440,17.939Z" /> </svg>';
				break;
				case '11':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '80';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="79.517" viewBox="0 0 1440 79.517" preserveAspectRatio="none">
							<path d="M1440,79.517V0H0V76.476L369,39.758,720,0l359.5,39.755Z" transform="translate(1440 79.517) rotate(180)"/>
						</svg>';
				break;
				case '12':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '150';
					$svg = '<svg width="1440" fill="' . $color . '" height="150" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none"  viewBox="0 0 1440 150">
						<path d="M 0 26.1978 C 275.76 83.8152 430.707 65.0509 716.279 25.6386 C 930.422 -3.86123 1210.32 -3.98357 1439 9.18045 C 2072.34 45.9691 2201.93 62.4429 2560 26.198 V 172.199 L 0 172.199 V 26.1978 Z">
							<animate repeatCount="indefinite" fill="freeze" attributeName="d" dur="10s" values="M0 25.9086C277 84.5821 433 65.736 720 25.9086C934.818 -3.9019 1214.06 -5.23669 1442 8.06597C2079 45.2421 2208 63.5007 2560 25.9088V171.91L0 171.91V25.9086Z; M0 86.3149C316 86.315 444 159.155 884 51.1554C1324 -56.8446 1320.29 34.1214 1538 70.4063C1814 116.407 2156 188.408 2560 86.315V232.317L0 232.316V86.3149Z; M0 53.6584C158 11.0001 213 0 363 0C513 0 855.555 115.001 1154 115.001C1440 115.001 1626 -38.0004 2560 53.6585V199.66L0 199.66V53.6584Z; M0 25.9086C277 84.5821 433 65.736 720 25.9086C934.818 -3.9019 1214.06 -5.23669 1442 8.06597C2079 45.2421 2208 63.5007 2560 25.9088V171.91L0 171.91V25.9086Z">
							</animate>
						</path>
					</svg>';
				break;
				case '13':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '430';
					$svg = '<svg width="1440" height="325" viewBox="0 0 1440 325" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
						<path d="M810.109 190.723V324.906H1439.97V141.635C1399.11 107.824 1358.5 72.4044 1316.96 48.4386C1146.99 -48.5261 971.704 0.680438 810.109 190.723Z" fill="#0A6373"/>
						<path d="M654.316 239.05C706.182 255.407 756.402 284.718 808.124 302.496C881.8 327.838 958.526 329.369 1032.09 303.091C1103.57 277.612 1177.69 215.47 1248.33 183.899C1310.97 155.889 1379.36 144.355 1440 179.351V324.595H366.918V283.141C458.546 224.252 557.938 209.003 654.316 239.052V239.05Z" fill="#E66C6C"/>
						<path d="M0 185.047L29.9989 177.248C59.9979 169.739 119.996 153.704 179.994 165.586C239.991 177.029 299.989 216.391 359.987 239.498C419.985 263.043 479.983 270.332 539.981 262.824C599.979 255.025 659.976 231.699 719.974 212.237C779.972 193.066 839.97 177.03 899.968 188.911C959.966 200.355 1019.96 239.717 1079.96 251.162C1139.96 263.043 1199.96 247.007 1259.95 251.162C1319.95 255.028 1379.95 278.35 1409.95 290.013L1439.97 301.858L1439.95 325H0V185.047Z" fill="' . $color . '"/>
					</svg>';
				break;
				case '14':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '150';
					$svg = '<svg width="1440" height="151" viewBox="0 0 1440 151" fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
						<path opacity="0.18" d="M0 97.8837H1439.96L1440 67.2712C1440 67.2712 1245.81 74.8642 1058.09 42.8292C832.056 4.26251 655.629 41.2185 630.846 45.4009C570.573 55.5822 479.478 87.5499 177.446 55.1029C64.351 41.2516 0 47.3878 0 47.3878V97.8837Z"/>
						<path d="M1440 150.004H0.039L0 86.6423C0 86.6423 184.667 102.389 363.176 36.0472C578.117 -43.8091 745.921 32.6886 769.451 41.3864C826.745 62.4698 913.412 128.631 1200.63 61.4617C1308.2 32.7572 1440 36.0421 1440 36.0421V150.004Z"/>
					</svg>
					';
				break;

			}

			return '<div class="one-row_' . $pos . '_divider ' . $bring_to_front . '" style="height:' . $height . 'px;">' . $svg . '</div>';

		}

	}

	new Liquid_Shape_Divider_Options;

}