# 🔐 WireGuard Telegram Bot for MikroTik

ربات تلگرام برای مدیریت کانفیگ‌های WireGuard روی میکروتیک

## ✨ امکانات

- ✅ ایجاد خودکار کانفیگ WireGuard با یک پیام
- ✅ تولید QR Code برای اسکن آسان
- ✅ تولید فایل .conf برای دانلود
- ✅ اضافه کردن خودکار peer به میکروتیک
- ✅ مدیریت IP Pool خودکار
- ✅ لیست و حذف peerها
- ✅ همگام‌سازی با میکروتیک

## 📋 پیش‌نیازها

- PHP 7.4+
- افزونه‌های PHP: curl, json, sodium
- SSL Certificate برای وب‌هوک تلگرام
- دسترسی API به میکروتیک (پورت 8728)

## 🚀 نصب

### 1. آپلود فایل‌ها

فایل‌ها را به سرور آپلود کنید:

```
/var/www/html/wgbot/
├── webhook.php
├── config.php
├── TelegramBot.php
├── WireGuardManager.php
├── MikroTikAPI.php
├── .htaccess
└── data/
    ├── peers.json
    ├── configs/
    └── qrcodes/
```

### 2. تنظیم دسترسی‌ها

```bash
chmod 755 /var/www/html/wgbot/
chmod 644 /var/www/html/wgbot/*.php
chmod 777 /var/www/html/wgbot/data/
chmod 777 /var/www/html/wgbot/data/configs/
chmod 777 /var/www/html/wgbot/data/qrcodes/
```

### 3. ویرایش config.php

```php
return [
    'telegram' => [
        'bot_token' => 'YOUR_BOT_TOKEN',  // از @BotFather بگیرید
        'admin_ids' => [123456789],        // آیدی عددی خودتان
    ],
    
    'wireguard' => [
        'server_endpoint' => 'afra.rangabi.ir',
        'server_port' => 55021,
        'server_private_key' => 'KPbEVDKV2u8OoPv7gtpSTlcfCWkLptR73ujmYl4vsGA=',
        'server_public_key' => 's/Her0o//FlAp7uh3wqAMfbvGgHaB2X47mSPR8qXZRU=',
        'interface' => 'wg0',
        'allowed_ips' => '0.0.0.0/0',
        'dns' => '1.1.1.1, 8.8.8.8',
    ],
    
    'ip_pool' => [
        'network' => '172.22.0.',
        'start' => 30,
        'end' => 245,
    ],
    
    'mikrotik' => [
        'host' => '192.168.1.1',  // آدرس میکروتیک
        'port' => 8728,
        'username' => 'admin',
        'password' => 'YOUR_PASSWORD',
    ],
];
```

### 4. فعال کردن API میکروتیک

در میکروتیک:
```
/ip service enable api
/ip service set api port=8728 address=YOUR_SERVER_IP/32
```

یا از WinBox:
- IP → Services → api → Enable
- تنظیم address محدود به IP سرور شما

### 5. ایجاد ربات تلگرام

1. به @BotFather بروید
2. `/newbot` را بزنید
3. نام و username ربات را وارد کنید
4. توکن را کپی کنید

### 6. گرفتن آیدی عددی تلگرام

به @userinfobot بروید و `/start` بزنید

### 7. تنظیم Webhook

در مرورگر بازدید کنید:
```
https://yourdomain.com/wgbot/webhook.php?action=setwebhook
```

## 📖 دستورات ربات

| دستور | توضیح |
|--------|--------|
| `/start` | شروع و خوش‌آمدگویی |
| `/help` | راهنمای دستورات |
| `/new [نام]` | ایجاد peer جدید |
| `/list` | لیست همه peerها |
| `/get [نام]` | دریافت کانفیگ |
| `/delete [نام]` | حذف peer |
| `/stats` | آمار سیستم |
| `/sync` | همگام‌سازی با میکروتیک |

💡 **نکته:** می‌توانید فقط یک نام تایپ کنید و ربات خودکار peer ایجاد می‌کند.

## 🔧 عیب‌یابی

### خطای اتصال به میکروتیک

1. بررسی فعال بودن API:
```
/ip service print
```

2. بررسی فایروال:
```
/ip firewall filter add chain=input dst-port=8728 protocol=tcp action=accept
```

3. تست اتصال:
```bash
telnet MIKROTIK_IP 8728
```

### خطای وب‌هوک

بررسی وضعیت:
```
https://yourdomain.com/wgbot/webhook.php?action=webhookinfo
```

### لاگ‌ها

فایل لاگ در:
```
/var/www/html/wgbot/data/log.txt
```

## 🔒 امنیت

1. **محدود کردن دسترسی API میکروتیک:**
```
/ip service set api address=YOUR_SERVER_IP/32
```

2. **استفاده از SSL برای وب‌هوک** (الزامی)

3. **محدود کردن admin_ids** فقط به خودتان

4. **تغییر پسورد API میکروتیک** به یک پسورد قوی

## 📝 مثال استفاده

1. نام peer را به ربات بفرستید:
```
user1
```

2. ربات تأیید می‌گیرد و بعد:
   - کانفیگ ایجاد می‌کند
   - QR Code می‌فرستد
   - فایل .conf می‌فرستد
   - به میکروتیک اضافه می‌کند

## 🆘 پشتیبانی

در صورت مشکل، فایل لاگ را بررسی کنید یا با ادمین تماس بگیرید.

---
Made with ❤️ for MikroTik admins
